#!/usr/bin/perl
########################################################################
#
# $Id: check_updates.pl,v 1.16 2024/10/01 12:01:46 gosha Exp $
#
#		(c) Okunev Igor <igor[at]prv.mts-nn.ru> 2012 - 2023
#
########################################################################
use strict;

open STDERR, '>>/var/log/VirtualPBX/XVB.stderr';

use LWP::UserAgent;
use HTTP::Request;

my $ua = LWP::UserAgent->new();
my %ver;
my $latest_ver;
my $cmd = 'rpm -qv virtual-pbx | sort | tail -1';
my $cur_ver = `$cmd`;
	
$cur_ver =~ s/virtual-pbx-.*_(\d+)(_dev)?(\.noarch)?$/$1/;
chomp( $cur_ver );

sleep(substr(int(int($cur_ver)/2),-3));

my $user = 'free';
my $calls = 10;

if ( -e '/opt/VirtualPBX/etc/key.lic' ) {
	if ( open(LIC,'</opt/VirtualPBX/etc/key.lic') ) {
		while(<LIC>) {
			if ( /Customer:\s*(.*)/) {
				$user = $1;
			} elsif ( /MaxCalls:\s*(\d+)/) {
				$calls = $1;
			}
		}
		close(LIC);
	}
}

$cmd = 'grep HIDE_UPDATES /opt/VirtualPBX/etc/xvb.cfg';
my $hide_updates = `$cmd`;

$cmd = 'host'.'name';
my $host_name = `$cmd`;
chomp $host_name;

$user = escape("$user - $calls [$host_name]");

my $req = HTTP::Request->new( GET => 'http://virtual-pbx.ru/cgi/checkupdates.cgi?ver='. $cur_ver .'&id='. $user );
my $res = $ua->request($req);

exit unless index($hide_updates,'HIDE_UPDATES');

unless ( $res->is_success ) {
	$req = HTTP::Request->new( GET => 'http://virtual-pbx.ru/updates/vpbx/' );
	$res = $ua->request($req);
}

%ver = ();

if ( $res->is_success ) {
	my $content = $res->content();

	foreach my $update ( $content =~ /(VirtualPBX-\d+.tgz)/g ) {
		if ( $update =~ /VirtualPBX-(\d+).tgz/ ) {
			$ver{$update} = $1;
		}
	}
	
	$latest_ver = $ver{(( sort { $ver{$b} <=> $ver{$a} } keys %ver ))[0]};
	
} else {
	print "<br /><br /><a class='error' href=''>!!! Unable to check updates !!!</a>";
}

if ( $latest_ver > $cur_ver ) {
	$req = HTTP::Request->new( GET => 'http://virtual-pbx.ru/changelog.html' );
	$res = $ua->request($req);
	my $label_str = '';
	my $change_count = 0;
	if ( $res->is_success ) {
		my $content = $res->content();
		my @content_str = split(/\n/,$content);
		foreach my $feature_str ( @content_str ) {
			if ( $feature_str =~ /<font color="green">(.*build\s+(\d+).*)/ ) {
				if ( $2 > $cur_ver ) {
					$label_str .= "$1\n";
					$change_count++;
				}
			}
		}
	}
	$label_str =~ s#'#"#gs;
	$label_str =~ s#</font>##gs;
	my $html_changelog = "<br /><textarea cols='60' rows='3' id='update_info' class='addon_info'>$label_str</textarea>";
	if ( $change_count < 15 ) {
		$label_str = "title='$label_str'";
	} else {
		$label_str = '';
	}
	print "<br /><br /><a class='error' href='http://virtual-pbx.ru/updates/vpbx/VirtualPBX-$latest_ver.tgz' $label_str>!!! Update to $latest_ver available !!!</a>";
	print "<a href='#' onclick='ShowEl(\"update_info\"); return false'>  ( changelog )</a>$html_changelog";
} else {
	print "";
}

sub escape {
	my $str = shift;

	$str =~ s#([^\w\d-])# '%'. unpack('H2', $1) #ge;

	return $str;
}

