#!/usr/bin/perl
########################################################################
#
# $Id: dashboard.pl,v 1.5 2019/06/25 13:52:16 gosha Exp $
#
#	Copyright (c) Igor Okunev <igor[at]prv.mts-nn.ru>
#
#						2013
#
########################################################################
package XVB::Dashboard;

use strict;
use CGI qw(:standard);
use JSON::XS;

require 'Mongo'.'DB.pm';


########################################################################
					main();
########################################################################

sub main {
	my $user_id = param('ac');
	my $action = param('action');

	my $mongo = MongoDB::Connection->new(host => '127.0.0.1', port => 27017);
	my $cdrs = $mongo->xvb->cdrs;

	print "Content-type: text/json\n\n";

	if ( $action eq 'stop' ) {
		my $chan = param('chan');
		my $data = $cdrs->find( { user_id => $user_id, xvb_id => $chan } );
		my $ast_chan;
		while (my $doc = $data->next) {
			$ast_chan = $doc->{'ast_id'};
			last;
		}
		if ( $ast_chan ) {
			system "/usr/sbin/asterisk -rx 'channel request hangup $ast_chan' &>/dev/null &";
		}
		print "{'status':0}";
	} elsif ( $action eq 'mute' ) {
		my $chan = param('chan');
		my $data = $cdrs->find( { user_id => $user_id, xvb_id => $chan } );
		my $ast_chan;
		while (my $doc = $data->next) {
			$ast_chan = $doc->{'ast_id'};
			last;
		}
		if ( $ast_chan ) {
			system "/opt/VirtualPBX/contrib/utils/chan_utils.pl mute '$ast_chan' &>/dev/null &";
		}
		print "{'status':0}";
	} elsif ( $action eq 'unmute' ) {
		my $chan = param('chan');
		my $data = $cdrs->find( { user_id => $user_id, xvb_id => $chan } );
		my $ast_chan;
		while (my $doc = $data->next) {
			$ast_chan = $doc->{'ast_id'};
			last;
		}
		if ( $ast_chan ) {
			system "/opt/VirtualPBX/contrib/utils/chan_utils.pl unmute '$ast_chan' &>/dev/null &";
		}
		print "{'status':0}";
	} elsif ( $action eq 'transfer' ) {
		my $chan = param('chan');
		my $tranfer_to = param('to');
		my $data = $cdrs->find( { user_id => $user_id, xvb_id => $chan } );
		my $ast_chan;
		while (my $doc = $data->next) {
			$ast_chan = $doc->{'ast_id'};
			last;
		}
		if ( $ast_chan ) {
			system "/opt/VirtualPBX/contrib/utils/chan_utils.pl transfer '$ast_chan' '$tranfer_to' &>/dev/null &";
		}
		print "{'status':0}";
	} elsif ( $action eq 'cleanup' ) {
		my $node = param('node');
		my $data = $cdrs->find( { node => $node } );

		my %mongo_chans;
		while (my $doc = $data->next) {
			$mongo_chans{$doc->{'ast_id'}} = 1;
		}
	
		if (keys %mongo_chans ) {
			my @channels = `/usr/sbin/asterisk -rx 'core show channels concise'`;
			chomp @channels;
			foreach my $channel ( @channels ) {
				my $live_chan = (split(/\!/,$channel))[0];
				delete $mongo_chans{$live_chan};
			}
			foreach my $stuck_chan ( keys %mongo_chans ) {
				$cdrs->remove( { ast_id => $stuck_chan } );
			}
		}
		print "{'status':0}";
	} else {
		my $data = $cdrs->find( { user_id => $user_id } );
		my @result;
		while (my $doc = $data->next) {
			push @result, { %$doc };
			delete $result[$#result]->{'_id'};
		}
		my $json = JSON::XS->new();
		print $json->encode(\@result);
	}
}

