########################################################################
#
# $Id: Skel.pm,v 1.2 2012-03-02 11:25:26 gosha Exp $
#
#	Copyright (c) Igor Okunev <igor[at]prv.mts-nn.ru>
#
#						2018
#
########################################################################
package XVBHooks::NumLog;

use strict;
use Fcntl qw(:flock);
use DB_File;

use vars qw( %hooks );

%hooks = (
				start	=> \&call_start,
				stop	=> \&call_stop
);

#
# call start hook
#
sub call_start {
	my $obj = shift;
	
	if ( $obj->{'_CDR'}->{'CALL_TYPE'} eq 'incoming' ) {
		
		my $caller_id = fix_callerid( (split(/\@/,$obj->{'_CDR'}->{'CALLER_ID'}))[0] );
		
		my %userhash;
		open( LOCK, ">>/opt/VirtualPBX/spool/helperdb/". $obj->{'_USER_CREDS'}->{'ACCESS_CODE'} .'-numlog' ) || die $!;
		flock( LOCK, LOCK_EX );
		dbmopen(%userhash,"/opt/VirtualPBX/spool/helperdb/". $obj->{'_USER_CREDS'}->{'ACCESS_CODE'} .'-numlog', 0644);
		#my ( $num, $time ) = split(/-:-/,$userhash{$caller_id} );
		if ( length($userhash{$caller_id}) ) {
			$obj->{'_SESSION'}->{'_USER_VARIABLES'}->{'EXT2INTMAP'} = $userhash{$caller_id}; 
		}
		dbmclose(%userhash);
		close( LOCK );
	}
}

#
# call stop hook
#
sub call_stop {
	my $obj = shift;

	my ( $ext, $int );

	if ( $obj->{'_CDR'}->{'CALL_TYPE'} eq 'transit' ) {
		$ext = fix_callerid( $obj->{'_CDR'}->{'CALLED_ID'} );
		$int = $obj->{'_CDR'}->{'CALLER_ID'};
	} elsif ( 
			not exists $obj->{'_SESSION'}->{'_USER_VARIABLES'}->{'EXT2INTMAP'} 
			and exists $obj->{'_SESSION'}->{'_USER_VARIABLES'}->{'LAST_ANSWERED_NUMBER'} ) {
		$ext = fix_callerid( (split(/\@/,$obj->{'_CDR'}->{'CALLER_ID'}))[0] );
		$int = $obj->{'_SESSION'}->{'_USER_VARIABLES'}->{'LAST_ANSWERED_NUMBER'};
	}

	if ( length($int) ) {
		my %userhash;
		open( LOCK, ">>/opt/VirtualPBX/spool/helperdb/". $obj->{'_USER_CREDS'}->{'ACCESS_CODE'} .'-numlog' ) || die $!;
		flock( LOCK, LOCK_EX );
		dbmopen(%userhash,"/opt/VirtualPBX/spool/helperdb/". $obj->{'_USER_CREDS'}->{'ACCESS_CODE'} .'-numlog', 0644);
		$userhash{$ext} = $int;
		dbmclose(%userhash);
		close( LOCK );
	}
}

#
# Caller ID fix - RU template
#
sub fix_callerid {
	my $caller_id = shift;

	$caller_id =~ s#^\+##;

	if ( length($caller_id) == 10 ) {
		$caller_id = '7'
	} elsif ( length($caller_id) == 11 ) {
		$caller_id =~ s#^8#7#;
	}

	return $caller_id;
}

1;

