#!/usr/bin/perl
########################################################################
#
# $Id: asterisk-watchdog.pl,v 1.3 2023/03/30 18:55:53 gosha Exp $
#
#  Okunev Igor <igor[at]prv.mts-nn.ru>
#
########################################################################
package VirtualPBX;

open STDERR, '>>/var/log/VirtualPBX/XVB.stderr';

use strict;

use lib qw( /opt/VirtualPBX/lib );

use Fcntl qw(F_GETFL F_SETFL O_NONBLOCK);
use IO::Socket::INET;
use Time::HiRes qw(time);

########################################################################

my %cmdopt = @ARGV;

#
my $ping_interval = $cmdopt{'-interval'} || 10;
my $timeout = $cmdopt{'-timeout'} || 3;
my $num = $cmdopt{'-tonumber'} || '10000000000';
my $asterisk_host = $cmdopt{'-ip'} || '127.0.0.1';
my $asterisk_port = $cmdopt{'-port'} || '5060';

my $reboot_timeout = 41;
my $log_file = '/var/log/asterisk-watchdog-reboot';

$SIG{'CHLD'} = 'IGNORE';

chdir('/opt/VirtualPBX/tmp');

########################################################################


########################################################################

while (1) {
	unless ( fork ) {
		sip_ping();
		exit;
	}
	sleep $ping_interval;
}

########################################################################
#
sub sip_ping {
	my $peers4ping = {};

	$peers4ping->{"$asterisk_host:$asterisk_port:udp"} = {	host	=> $asterisk_host, 
															port	=> $asterisk_port,
															proto	=> 'udp',
															status	=> -1
										};
	sip_ping_direct($peers4ping);

	foreach my $peer_ip ( keys %$peers4ping ) {
		if ( $peers4ping->{$peer_ip}->{'status'} == 0 ) {
			print STDERR scalar(localtime);
			if ( ! -e $log_file or (stat($log_file))[9]+$reboot_timeout < time ) {
				print STDERR " Dead host detected\n";
				print STDERR " try to double ping\n";
				system("( date; uptime; ps ax | grep asterisk ) >> $log_file");
				$timeout--;
				sip_ping_direct($peers4ping);
				if ( $peers4ping->{$peer_ip}->{'status'} == 0 ) {
					print STDERR " dead host confirm, try to restart asterisk\n";
					my $pid = `ps ax | grep '/[uU]sr/sbin/asterisk'`;
					if ( $pid =~ /^(\d+)/ ) {
						system("timeout 15 /usr/bin/gcore $1 >&2");
					}
					system("killall -9 asterisk");
					system("/opt/VirtualPBX/contrib/utils/user_counters.pl all clean");
					sleep(3);
				} else {
					print STDERR " looks good\n";
				}
				system("(date; uptime; ps ax | grep asterisk) >> $log_file");
			} else {
				print STDERR " Dead host detected skip to restart asterisk\n";
			}
		}
	}
}

################################################################################3
#
# Direct pings
#
sub sip_ping_direct {
	my ( $peers ) = @_;

	my %result;

	foreach my $l_ip ( keys %$peers ) {
		my $s_ip = $peers->{$l_ip}->{'host'};
		my $s_port = $peers->{$l_ip}->{'port'};

		my $socket;

		next if $peers->{$l_ip}->{'proto'} ne 'udp';

		if ( $socket = new IO::Socket::INET->new( PeerAddr => $s_ip, PeerPort => $s_port, Timeout => $timeout , Proto => 'udp' ) ) {
			my $tag = join('', ( sort{ rand(1000)<=>rand(1000) } ('a'..'z',0..9) )[0..5] );
			
			my ( $localport, $localhost ) = unpack_sockaddr_in( $socket->sockname );
			$localhost = inet_ntoa( $localhost );
			
			my $call_id = $tag .'-'. time ."\@$localhost";

			my $msg = "OPTIONS sip:$num\@$s_ip:$s_port SIP/2.0\r\n".
						 "Via: SIP/2.0/UDP $localhost:$localport;branch=". "$tag"x3 ."\r\n".
						 "Max-Forwards: 70\r\n".
						 "To: <sip:$num\@$s_ip>\r\n".
						 "From: <sip:sipchecker\@$localhost>;tag=$tag\r\n".
						 "Call-ID: $call_id\r\n".
						 "CSeq: 1 OPTIONS\r\n".
						 "Contact: <sipchecker\@$localhost:$localport>\r\n".
						 "Accept: application/sdp\r\n".
						 "Content-Length: 0\r\n\r\n";

			my $flags = fcntl($socket, F_GETFL, 0);
			$flags = fcntl($socket, F_SETFL, $flags | O_NONBLOCK);

			if ( $socket->send($msg) ) {
				$result{$l_ip} = $socket;
				$peers->{ $l_ip }->{'status'} = 0;
			}
		}
	}

	my $read_attempts = 1000;

	my $start_time = time+$timeout;
		
	while ( ($read_attempts > 0) and (time < $start_time) ) {
		foreach my $l_ip ( keys %result ) {
			select(undef, undef, undef, 0.001);
			my $response;
			$result{$l_ip}->recv( $response, 1024 );
			if ( length $response ) {
				my @str = split(/\n/,$response,2);
				$str[0] =~ s#[\r\n]##gs;
				delete $result{$l_ip};
				$peers->{ $l_ip }->{'status'} = 1;
				$peers->{ $l_ip }->{'responce'} = $str[0];
			}
		}
		last unless keys %result;
		$read_attempts--;
	}
}
