#!/usr/bin/perl
########################################################################
#
# $Id: billing_gw.pl,v 1.4 2022/06/14 18:16:31 gosha Exp $
#
#				Ext Bill example
#		(c) Okunev Igor <igor[at]prv.mts-nn.ru>
#					2016 - 2022
#
########################################################################
package VirtualPBXBillingGW;

open STDERR, '>>/var/log/VirtualPBX/XVB.stderr';

use strict;
use Fcntl qw(:flock);
use DB_File;
use Digest::MD5 qw(md5_base64);
use JSON::XS;

use CGI;

########################################################################
							main();
########################################################################

########################################################################
#
sub main {
	my $cgi = CGI->new();

	my $bill_data = $cgi->param('bill_data');

	if ( length($bill_data) ) {
		eval {
			my $json = JSON::XS->new();
			$bill_data = $json->decode( $bill_data );
		};
	}
	
	print 'Content-type: text/plain', "\n\n";
	
	if ( $@ or ref $bill_data ne 'ARRAY' ) {
		print STDERR "Json err: $@\n";
		print '0';
		return;
	}

	my $call_cost = 0;
	my $debug_log = "\n";

	my %rates;

	dbmopen( %rates, '/opt/VirtualPBX/spool/rates', 0644);
	
	foreach my $h_ref ( @{$bill_data} ) {
		if ( ref $h_ref eq 'HASH' ) {
			my ( $called, $duration, $gw );
			if ( $h_ref->{'TYPE'} eq 'XVB' ) {
				if ( $h_ref->{'STATUS'} eq 'ANSWER' ) {
					if ( $h_ref->{'CALL_TYPE'} eq 'transit' ) {
						$called = $h_ref->{'CALLED_ID'};
					} elsif ( $h_ref->{'CALL_TYPE'} =~ /(alarmclock|callblast|callback|click2call)/ ) {
						$called = $h_ref->{'CALLER_ID'};
					}
					$duration = $h_ref->{'STOP_TIMESTAMP'} - $h_ref->{'START_TIMESTAMP'};
				}
			#} elsif ( $h_ref->{'TYPE'} =~ /(Transfer|Intercom|Dialout|DISA|Queue|MultiDialout)/ ) {
			} elsif ( $h_ref->{'TYPE'} =~ /(Transfer|Dialout|DISA|Queue|MultiDialout)/ ) {
				if ( $h_ref->{'STATUS'} eq 'ANSWER' ) {
					$called = $h_ref->{'PN'};
					$duration = $h_ref->{'DURATION'};
				}
			}
			$gw = $h_ref->{'GW'};

			if ( $duration and $called and $gw eq 'system' ) {
				for ( my $i=length($called); $i >= 1; $i-- ) {
					if ( length($rates{ substr($called,0,$i) }) ) {
						my @rate_data = split(/\x00/,$rates{ substr($called,0,$i) });
						my $min = int($duration/60);
						$min++ if $duration % 60;
						$call_cost += $rate_data[0]*$min;
						$debug_log .= join("\n",@rate_data,"-------\n");
						last;
					}
				}
			}
		}
	}
	
	dbmclose( %rates );

	print $call_cost;
	#print $debug_log;
}

