#!/usr/bin/perl
########################################################################
#
# $Id: sys_update.pl,v 1.79 2025/10/30 18:23:23 gosha Exp $
#
#		2012 - 2025 (c) Okunev Igor <igor[at]prv.mts-nn.ru>
#
########################################################################
package VirtualPBX;

open STDERR, '>>/var/log/VirtualPBX/XVB.stderr';

use strict;

use vars qw( $VERSION );

($VERSION='$Revision: 1.79 $')=~s/^\S+\s+\d+\.(\d+)\s+.*/$1/;

########################################################################
my %update_data = (
	# top release :)
	"1000000"	=>	[
			sub { print OUT "SYS-VERSION=$VERSION, DATE=". scalar(localtime(time)) ."\n" }
	],
	
	"$VERSION"	=>	[
		sub {
			my @files = `find /usr/share/asterisk/sounds -name 'gotoif-intro.ulaw'`;
			chomp @files;
			foreach my $fn ( @files ) {
				my $new_fn = $fn;
				$new_fn =~ s{gotoif-intro\.ulaw$}{websocket-intro.ulaw};
				run_sys("cp $fn $new_fn");
			}
		}
	],
	
	"78"	=>	[
		sub {
			my $is_ru = `grep 'DEFAULT_LANG\\s*=\\s*xvb.RU' /opt/VirtualPBX/etc/xvb.cfg`;
			if ( length($is_ru) ) {
				open(XVB,'>>/opt/VirtualPBX/etc/xvb.cfg');
				print XVB "\n[COMMON]\nDEFAULT_LANG_AI = xvb.RU-Male\n";
				close XVB;
			}
		}
	],

	"76"	=>	[
		sub {
			my @files = `find /usr/share/asterisk/sounds -name 'gotoif-intro.ulaw'`;
			chomp @files;
			foreach my $fn ( @files ) {
				my $new_fn = $fn;
				$new_fn =~ s{gotoif-intro\.ulaw$}{pause-intro.ulaw};
				run_sys("cp $fn $new_fn");
			}
		}
	],

	"75"	=>	[
		sub {
			#print "\n\n\033[5m!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!\033[0m\nYou can apply some performance improvements for sql manually, please run:\nmysql xvb < /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/cdr_index.sql\nIt will take some time, because of this it not started automatically.\n\n";
		}
	],

	"72"	=>	[
		sub {
			run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-160422.sh');
		}
	],

	"71"	=>	[
		sub {
			system "sed -i 's#1000(post_agi)#1500(post_agi)#' /etc/asterisk/xvb/xvb-post-agi.conf 2> /dev/null";
			system "/usr/sbin/asterisk -rx 'dialplan reload' &>/dev/null";
		}
	],

	"68"	=>	[
		sub {
			my @files = `find '/opt/VirtualPBX/sounds/' -name 'multidialout-note.*'`;
			chomp @files;
			foreach my $file ( @files ) {
				my $new_file = $file;
				$new_file =~ s{multidialout-note}{queues-note};
				unless ( -e $new_file ) { 
					system "cp $file $new_file";
				}
			}
		}
	],

	"67"	=>	[
		sub {
			my @files = `find '/opt/VirtualPBX/sounds/' -name 'multidialout-note.*'`;
			chomp @files;
			foreach my $file ( @files ) {
				my $new_file = $file;
				$new_file =~ s{multidialout-note}{callblast-note};
				unless ( -e $new_file ) { 
					system "cp $file $new_file";
				}
			}
		}
	],
	
	"65"	=>	[
		sub {
			system "mkdir -p /opt/VirtualPBX/spool/backups/db && mv /opt/VirtualPBX/db/* /opt/VirtualPBX/spool/backups/db/ && rmdir /opt/VirtualPBX/db";
			system "mkdir -p /opt/VirtualPBX/spool/backups/ui && mv /opt/VirtualPBX/spool/backups/[0-9]* /opt/VirtualPBX/spool/backups/ui/";
		}
	],

	"64"	=>	[
		sub {
			if ( -e '/usr/local/bin/set-node-ip.pl' ) {
				system "mv /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/set-node-ip.pl /usr/local/bin/ && chmod +x /usr/local/bin/set-node-ip.pl" 
			}
		}
	],
	
	"63"	=>	[
		sub {
			system "echo 'asterisk  ALL=(ALL)       NOPASSWD:/opt/VirtualPBX/contrib/utils/sysstatus.pl' > /etc/sudoers.d/xvb-sysstat";
		}
	],
	
	"62"	=>	[
		sub {
			system "echo 'asterisk  ALL=(ALL)       NOPASSWD:/usr/bin/fail2ban-client' > /etc/sudoers.d/xvb-f2b";
		}
	],
	
	"61"	=>	[
		sub {
			system "perl -i -p -e 's/(ACC_FIELDS\\s*=\\s*)/\${1}CUSTOM_VARS,/' /opt/VirtualPBX/etc/xvb.cfg";
		}
	],
	
	"60"	=>	[
		sub {
			open(XVBRC,'>>/opt/VirtualPBX/etc/xvb-rc.cfg');
			print XVBRC "\nTCPDUMP_PORT=5060\n";
			close XVBRC;
		}
	],

	"59"	=>	[
		sub {
			open(XVBRC,'>>/opt/VirtualPBX/etc/xvb-rc.cfg');
			print XVBRC "\n\nTCPDUMP_SIZE=10\nTCPDUMP_CHUNKS=10\nTCPDUMP_DEV=any\n";
			close XVBRC;
		}
	],

	"56"	=>	[
		sub {
			run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-010518.sh');
			my @files = `find /usr/share/asterisk/sounds -name 'disa-intro.ulaw'`;
			chomp @files;
			foreach my $fn ( @files ) {
				my $new_fn = $fn;
				$new_fn =~ s{disa-intro\.ulaw$}{pbx-conf4call.ulaw};
				run_sys("cp $fn $new_fn");
			}
		}
	],

	"54"	=>	[
		sub {
			unless ( -e '/var/www/html/index.html' ) {
				open(INDEXHTML,'>/var/www/html/index.html');
				print INDEXHTML "<head><meta http-equiv='refresh' content='0;URL=/ui' /></head>";
				close INDEXHTML;
			}
		}
	],

	"53"	=>	[
		sub {
			my $sys = `uname -a | grep el6.i686`;	
			if ( $sys =~ /i686/ ) {
				system('cd /tmp && wget http://virtual-pbx.ru/downloads/ffmpeg4vpbx.tgz');
				system('cat /tmp/ffmpeg4vpbx.tgz | (cd /opt; tar -xzf - )');
				system('/opt/ffmpeg4vpbx/.install.sh');
			}
		}
	],

	"52"	=>	[
		sub {
			system "perl -i -p -e 's/NOINDEX_LIMIT\\s*=\\s*14/NOINDEX_LIMIT = 16/' /opt/VirtualPBX/etc/xvb.cfg";
		}
	],

	"50"	=>	[
		sub {
				my $ip = `curl -m 10 http://freegeoip.net/csv/`;
				if ( $ip =~ /,RU,Russia,/ ) {
					system( 'echo -e "[COMMON]\nGEO_INFO = RU" >> /opt/VirtualPBX/etc/xvb.cfg' );
					system( 'perl /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/create_geo_info_db.pl 2> /dev/null > /tmp/geodbinit.log &' );
					system( 'chmod +x /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/create_geo_info_db.pl && ln -s /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/create_geo_info_db.pl /etc/cron.monthly/xvb-create_geo_info_db' );
				}
		}
	],

	"44"	=>	[
		sub {
			system('perl /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/addtmpl.pl /opt/VirtualPBX/etc/xvb.cfg');
		}
	],

	"43"	=>	[
		sub {
			run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-14112016.sh');
		}
	],
	
	"42"	=>	[
		sub {
			run_sys('ln -s /opt/VirtualPBX/spool/tts /opt/VirtualPBX/tts');
		}
	],

	"41"	=>	[
		sub {
			run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-20150305.sh');
		}
	],

	"39"	=>	[
		sub {
			system('perl /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/fixfeature.pl /etc/asterisk/features.conf');
			system('perl /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/fixfeature.pl /opt/VirtualPBX/etc/xvb.cfg');
		}
	],
			
	"37"	=>	[
		sub {
			system "perl -i.xvb-bak -pne 's#/var/log/VirtualPBX/XVB.log#/var/log/VirtualPBX/XVB.secure#' /etc/fail2ban/jail.conf";
			system "fail2ban-client reload &>/dev/null &";
		}
	],

	"36"	=>	[
		sub {
			open(LYNX,'>>/etc/lynx-site.cfg');
			print LYNX "\n######### XVB-PBX ############\nLOCALE_CHARSET:FALSE\nASSUME_CHARSET:utf-8\nCHARACTER_SET:utf-8\nMAKE_PSEUDO_ALTS_FOR_INLINES:FALSE\n";
			close LYNX;
		}
	],

	"32"	=>	[
		sub {
			run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-19022015.sh');
		}
	],

	"30"	=>	[
		sub {
			# add saved file
			unless ( -e "/opt/VirtualPBX/sounds/xvb.EN-Male/directory-intro3.ulaw" ) {
				run_sys('cp -a /opt/VirtualPBX/sounds/xvb.EN-Male/directory-intro2.ulaw /opt/VirtualPBX/sounds/xvb.EN-Male/directory-intro3.ulaw');
				run_sys('cp -a /opt/VirtualPBX/sounds/xvb.RU-Male/directory-intro2.ulaw /opt/VirtualPBX/sounds/xvb.RU-Male/directory-intro3.ulaw');
				run_sys('cp -a /opt/VirtualPBX/sounds/xvb.EN-Female/directory-intro2.ulaw /opt/VirtualPBX/sounds/xvb.EN-Female/directory-intro3.ulaw');
				run_sys('cp -a /opt/VirtualPBX/sounds/xvb.RU-Female/directory-intro2.ulaw /opt/VirtualPBX/sounds/xvb.RU-Female/directory-intro3.ulaw');
			}
		}
	],
		
	"29"	=>	[
		sub {
			if ( -f '/opt/VirtualPBX/contrib/utils/rpm/sys_update-data/rec_migrate.pl' ) {
				run_sys('perl /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/rec_migrate.pl');
			}
		}
	],

	"28"	=>	[
		sub {
			# add saved file
			unless ( -e "/opt/VirtualPBX/sounds/xvb.EN-Male/multidialout-note.ulaw" ) {
				run_sys('cp -a /opt/VirtualPBX/sounds/xvb.EN-Male/tts-input-params.ulaw /opt/VirtualPBX/sounds/xvb.EN-Male/multidialout-note.ulaw');
				run_sys('cp -a /opt/VirtualPBX/sounds/xvb.RU-Male/tts-input-params.ulaw /opt/VirtualPBX/sounds/xvb.RU-Male/multidialout-note.ulaw');
				run_sys('cp -a /opt/VirtualPBX/sounds/xvb.EN-Female/tts-input-params.ulaw /opt/VirtualPBX/sounds/xvb.EN-Female/multidialout-note.ulaw');
				run_sys('cp -a /opt/VirtualPBX/sounds/xvb.RU-Female/tts-input-params.ulaw /opt/VirtualPBX/sounds/xvb.RU-Female/multidialout-note.ulaw');
			}
		}
	],

	"27"	=>	[
		sub {
			system "perl -i -p -e 's/(ACC_FIELDS\\s*=\\s*)/\${1}CID_URL,/' /opt/VirtualPBX/etc/xvb.cfg";
		}
	],

	"26"	=>	[
		sub {
			# s for OPTIONS requests
			unless ( -e '/usr/bin/xvb-ctl' ) {
				run_sys('ln -s /opt/VirtualPBX/contrib/utils/xvb-ctl /usr/bin/xvb-ctl');
			}
		}
	],
	
	"25"	=>	[
		sub {
			# s for OPTIONS requests
			if ( -f '/opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-03072014.sh' ) {
				run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-03072014.sh');
			}
		}
	],
	
	"23"	=>	[
		sub {
			# Features
			run_sys('perl /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-23052014.sh &>/tmp/update.log &');
		}
	],
	
	"21"	=>	[
		sub {
			# add saved file
			unless ( -e "/opt/VirtualPBX/sounds/xvb.EN-Male/saved.ulaw" ) {
				run_sys('cp -a /opt/VirtualPBX/sounds/xvb.EN-Male/gc-explorer-saved.ulaw /opt/VirtualPBX/sounds/xvb.EN-Male/saved.ulaw');
				run_sys('cp -a /opt/VirtualPBX/sounds/xvb.RU-Male/gc-explorer-saved.ulaw /opt/VirtualPBX/sounds/xvb.RU-Male/saved.ulaw');
				run_sys('cp -a /opt/VirtualPBX/sounds/xvb.EN-Female/gc-explorer-saved.ulaw /opt/VirtualPBX/sounds/xvb.EN-Female/saved.ulaw');
				run_sys('cp -a /opt/VirtualPBX/sounds/xvb.RU-Female/gc-explorer-saved.ulaw /opt/VirtualPBX/sounds/xvb.RU-Female/saved.ulaw');
			}
		}
	],

	"19"	=>	[
		sub {
			# TTS CACHE
			run_sys('perl /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-31012014.pl &>/tmp/update.log &');
		}
	],
	
	"18"	=>	[
		sub {
			# MemCache
			run_sys('perl /opt/VirtualPBX/contrib/utils/MemCached.pl');
		}
	],
	
	"17"	=>	[
		sub {
			# app_directed_pickup.so
			if ( -f '/opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-030913.sh' ) {
				run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-030913.sh');
			}
		}
	],

	"16"	=>	[
		sub {
			# sudoers
			system "perl -i.xvb-bak6 -pne 's/^(Defaults\\s+requiretty)/#\$1\\n/' /etc/sudoers";
		}
	],

	"15"	=>	[
		sub {
			# sipusers
			if ( -f '/opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-150313.sh' ) {
				run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-150313.sh');
			}
		}
	],
	
	"14"	=>	[
		sub {
			# peerip => recvip
			if ( -f '/opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-221012.sh' ) {
				run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-221012.sh');
			}
		}
	],

	"13"	=>	[
		sub {
			# app_exec
			if ( -f '/opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-061012.sh' ) {
				run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-061012.sh');
			}
		}
	],

	"12"	=>	[
		sub {
			# app_while
			if ( -f '/opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-060912.sh' ) {
				run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-060912.sh');
			}
		}
	],

	"11"	=>	[
		sub {
			# MemCache updates
			if ( -f '/opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-140812.sh' ) {
				run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-140812.sh');
			}
		}
	],
	
	"9"	=>	[
		sub {
			# features tune
			if ( -f '/opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-070612.sh' ) {
				run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-070612.sh');
			}
		}
	],

	"8"	=>	[
		sub {
			my @files = `find '/opt/VirtualPBX/sounds/' -name 'schedule-intro.*'`;
			chomp @files;
			foreach my $file ( @files ) {
				my $new_file = $file;
				$new_file =~ s{schedule-intro}{dtmftx-intro};
				unless ( -e $new_file ) { 
					system "cp $file $new_file";
				}
			}
		}
	],

	"7"	=>	[
		sub {
			# manager tune
			if ( -f '/opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-200312.sh' ) {
				run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-200312.sh');
			}
		}
	],

	"6"	=>	[
		sub {
			# fix asterisk binaries
			if ( -f '/usr/lib/asterisk/modules/app_chanspy.so' && -f '/opt/VirtualPBX/contrib/utils/rpm/sys_update-data/app_chanspy-1.6.0.28-XVB.6.so.gz' ) {
				my $cmd = 'rpm -qv virtual-pbx';
				my $str = `$cmd`;
				if ( $str =~ /1\.6\.0\.28-XVB\.(\d+)/ and $1 < 6 ) {
					$cmd = "zcat /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/app_chanspy-1.6.0.28-XVB.6.so.gz | md5sum | awk '{print ".'$1'."}'"; 
					my $md5_1 = `$cmd`;
					$cmd = "md5sum /usr/lib/asterisk/modules/app_chanspy.so | awk '{print ".'$1'."}'"; 
					my $md5_2 = `$cmd`;
					chomp $md5_2;
					chomp $md5_1;
					if ( $md5_1 ne $md5_2 ) {
						run_sys("asterisk -rx 'module unload app_chanspy.so'");
						run_sys('zcat /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/app_chanspy-1.6.0.28-XVB.6.so.gz > /usr/lib/asterisk/modules/app_chanspy.so');
						run_sys('chmod 755 /usr/lib/asterisk/modules/app_chanspy.so');
						run_sys("asterisk -rx 'module load app_chanspy.so'");
					}
				}	
			}
		}
	],

	"5"	=>	[
		sub {
			# DID routing
			if ( -f '/opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-240212.sh' ) {
				run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-240212.sh');
			}
		}
	],

	"4"	=>	[
		sub {
			# ast conf
			if ( -f '/opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-210212.sh' ) {
				run_sys('bash /opt/VirtualPBX/contrib/utils/rpm/sys_update-data/upd-210212.sh');
			}
		}
	]
);

########################################################################
							main();
########################################################################

########################################################################
#
sub main {
	my $cur_version = '0';

	my $start_time = localtime;

	if ( -e '/opt/VirtualPBX/etc/.sys_version' ) {
		open( IN, '</opt/VirtualPBX/etc/.sys_version' ) || die "Can't open config file for read: $!";
		while ( <IN> ) {
			$cur_version = $1 if /SYS-VERSION=(\d+)/;
		}
		close(IN);
	
		print "Start update system ( from $cur_version to $VERSION ): $start_time...\n";

		if ( $cur_version ne $VERSION ) {
			open( OUT, '>>/opt/VirtualPBX/etc/.sys_version' ) || die "Can't open config file for write: $!";
			foreach my $key ( sort { $a <=> $b } keys %update_data ) {
				next if $key <= $cur_version;
				foreach my $conf ( @{ $update_data{$key} } ) {
					&$conf() if ref $conf eq 'CODE';
				}
			}
			close OUT;
		}
	} else {
		open( OUT, '>>/opt/VirtualPBX/etc/.sys_version' ) || die "Can't open config file for write: $!";
		print OUT "SYS-VERSION=$VERSION, DATE=". scalar(localtime(time)) ."\n";
		close OUT;
	}

	my $stop_time = localtime;
	print "Complite update system: $stop_time...\n";
}

########################################################################
#
sub run_sys {
	my $cmd = shift;

	if ( system($cmd) ) {
		print "RUN CMD ERROR[$cmd]: $!\n";
		die "RUN CMD ERROR[$cmd]: $!\n";
	}
}
