########################################################################
#
# $Id: Skel.pm,v 1.5 2022/01/15 14:56:38 gosha Exp $
#
#	Copyright (c) Igor Okunev <igor[at]prv.mts-nn.ru>
#
#						2012 - 2022
#
########################################################################
package XVBHooks::Skel;

use strict;

use vars qw( %hooks );

%hooks = (
				start	=> \&call_start,
				stop	=> \&call_stop,
				message	=> \&msg_rec,
				vbrun	=> \&vb_run
);

#
# call start hook
#
sub call_start {
	my $obj = shift;

	$obj->{'_AGI'}->verbose(	'Start call with type: '. 
								$obj->{'_CDR'}->{'CALL_TYPE'} .
								' for ac: '. 
								$obj->{'_USER_CREDS'}->{'ACCESS_CODE'} );
}

#
# call stop hook
#
sub call_stop {
	my $obj = shift;

	$obj->{'_AGI'}->verbose(	'Stop call, duration: '. 
								(time - $obj->{'_CDR'}->{'CALL_START'}) );
}

#
# record message hook
#
sub msg_rec {
	my ( $obj, $meta ) = @_;

	$obj->{'_AGI'}->verbose( 'Record message: '. $meta->{'recorded'}.', duration: '. $meta->{'duration'} .', keep = '. ( $meta->{'no_keep'} ? 'no':'yes' ) );
}

#
# start vb
#
sub vb_run {
	my ( $obj, $ext_id ) = @_;

	$obj->{'_AGI'}->verbose( 'IVR run : '. $ext_id );
}

1;

